// Content script — bridges the Reach web app and extension.
// Runs on the Reach domain so the page can detect the extension
// and push configuration (API endpoint + auth token) without
// needing a known extension ID or externally_connectable.

document.documentElement.setAttribute('data-reach-extension', 'installed');
window.dispatchEvent(new CustomEvent('reach-extension-ready'));

window.addEventListener('reach-configure', (event) => {
  const { apiEndpoint, authToken } = event.detail || {};
  if (!apiEndpoint || !authToken) return;

  chrome.runtime.sendMessage(
    { type: 'CONFIGURE', apiEndpoint, authToken },
    () => {
      window.dispatchEvent(new CustomEvent('reach-configured'));
    }
  );
});
