// Reach extension background service worker
// Minimal — just keeps the extension alive for popup use

chrome.runtime.onInstalled.addListener(() => {
  console.log('Reach extension installed');
});

chrome.runtime.onMessage.addListener((msg, _sender, sendResponse) => {
  if (msg.type === 'PING') {
    sendResponse({ ok: true });
    return true;
  }

  if (msg.type === 'CONFIGURE') {
    chrome.storage.sync.set(
      { apiEndpoint: msg.apiEndpoint, authToken: msg.authToken },
      () => sendResponse({ ok: true })
    );
    return true;
  }

  return true;
});
